/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.spring;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgConnectionImpl;
import io.github.mfvanek.pg.spring.DatabaseStructureHealthCondition;
import io.github.mfvanek.pg.spring.DatabaseStructureHealthProperties;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DatabaseStructureHealthProperties.class})
@ConditionalOnClass(value={DataSource.class}, name={"org.postgresql.Driver"})
@Conditional(value={DatabaseStructureHealthCondition.class})
@ConditionalOnProperty(name={"pg.index.health.test.enabled"}, matchIfMissing=true, havingValue="true")
public class DatabaseStructureHealthAutoConfiguration {
    private final DatabaseStructureHealthProperties properties;

    public DatabaseStructureHealthAutoConfiguration(DatabaseStructureHealthProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean
    public PgConnection pgConnection(BeanFactory beanFactory, Environment environment) {
        DataSource dataSource = (DataSource)beanFactory.getBean(this.properties.getDatasourceBeanName(), DataSource.class);
        String databaseUrl = environment.getProperty(this.properties.getDatasourceUrlPropertyName());
        return PgConnectionImpl.ofUrl((DataSource)dataSource, (String)databaseUrl);
    }
}

