/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.spring;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DatabaseStructureHealthCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"pg.index.health.test PostgreSQL condition", (Object[])new Object[0]);
        String datasourceUrlPropertyName = DatabaseStructureHealthCondition.getDatasourceUrlPropertyName(context);
        String jdbcUrl = DatabaseStructureHealthCondition.getJdbcUrl(context, datasourceUrlPropertyName);
        if (jdbcUrl != null && !jdbcUrl.isBlank()) {
            if (jdbcUrl.startsWith("jdbc:postgresql://") || jdbcUrl.startsWith("jdbc:tc:postgresql:")) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("found PostgreSQL connection " + jdbcUrl)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("not PostgreSQL connection"));
        }
        return ConditionOutcome.match((ConditionMessage)message.didNotFind(datasourceUrlPropertyName).items(new Object[0]));
    }

    private static @Nullable String getJdbcUrl(ConditionContext context, String datasourceUrlPropertyName) {
        return (String)Binder.get((Environment)context.getEnvironment()).bind(datasourceUrlPropertyName, String.class).orElse(null);
    }

    private static String getDatasourceUrlPropertyName(ConditionContext context) {
        return (String)Binder.get((Environment)context.getEnvironment()).bind("pg.index.health.test.datasource-url-property-name", String.class).orElse((Object)"spring.datasource.url");
    }
}

