/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.spring;

import io.github.mfvanek.pg.model.validation.Validators;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.DefaultValue;

@ConfigurationProperties(prefix="pg.index.health.test")
public class DatabaseStructureHealthProperties {
    public static final String STANDARD_DATASOURCE_BEAN_NAME = "dataSource";
    public static final String STANDARD_DATASOURCE_URL_PROPERTY_NAME = "spring.datasource.url";
    private final boolean enabled;
    private final String datasourceBeanName;
    private final String datasourceUrlPropertyName;

    public DatabaseStructureHealthProperties(@DefaultValue(value={"true"}) boolean enabled, @DefaultValue(value={"dataSource"}) String datasourceBeanName, @DefaultValue(value={"spring.datasource.url"}) String datasourceUrlPropertyName) {
        this.enabled = enabled;
        this.datasourceBeanName = Validators.notBlank((String)datasourceBeanName, (String)"datasourceBeanName");
        this.datasourceUrlPropertyName = Validators.notBlank((String)datasourceUrlPropertyName, (String)"datasourceUrlPropertyName");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDatasourceBeanName() {
        return this.datasourceBeanName;
    }

    public String getDatasourceUrlPropertyName() {
        return this.datasourceUrlPropertyName;
    }

    public String toString() {
        return DatabaseStructureHealthProperties.class.getSimpleName() + "{enabled=" + this.enabled + ", datasourceBeanName='" + this.datasourceBeanName + "', datasourceUrlPropertyName='" + this.datasourceUrlPropertyName + "'}";
    }
}

