/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.testing;

import io.github.mfvanek.pg.testing.PostgreSqlClusterWrapper;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Immutable
final class PostgreSqlClusterAliasHolder {
    static final Duration STARTUP_TIMEOUT = Duration.ofSeconds(40L);
    private final String primaryAlias;
    private final String standbyAlias;

    PostgreSqlClusterAliasHolder() {
        UUID uuid = UUID.randomUUID();
        this.primaryAlias = String.format("pg-%s-0", uuid);
        this.standbyAlias = String.format("pg-%s-1", uuid);
    }

    @Nonnull
    String getPrimaryAlias() {
        return this.primaryAlias;
    }

    @Nonnull
    String getStandbyAlias() {
        return this.standbyAlias;
    }

    @Nonnull
    Map<String, String> createPrimaryEnvVarsMap(@Nonnull PostgreSqlClusterWrapper.PostgreSqlClusterBuilder builder) {
        Map<String, String> envVarsMap = this.createCommonEnvVarsMap(builder);
        envVarsMap.put("REPMGR_NODE_NAME", this.primaryAlias);
        envVarsMap.put("REPMGR_NODE_NETWORK_NAME", this.primaryAlias);
        return envVarsMap;
    }

    @Nonnull
    Map<String, String> createStandbyEnvVarsMap(@Nonnull PostgreSqlClusterWrapper.PostgreSqlClusterBuilder builder) {
        Map<String, String> envVarsMap = this.createCommonEnvVarsMap(builder);
        envVarsMap.put("REPMGR_NODE_NAME", this.standbyAlias);
        envVarsMap.put("REPMGR_NODE_NETWORK_NAME", this.standbyAlias);
        return envVarsMap;
    }

    @Nonnull
    WaitStrategy getWaitStrategyForPrimary() {
        return new LogMessageWaitStrategy().withRegEx(".*Starting repmgrd.*\\s").withStartupTimeout(STARTUP_TIMEOUT);
    }

    @Nonnull
    WaitStrategy getWaitStrategyForStandBy() {
        return new LogMessageWaitStrategy().withRegEx(".*starting monitoring of node.*\\s").withStartupTimeout(STARTUP_TIMEOUT);
    }

    @Nonnull
    private Map<String, String> createCommonEnvVarsMap(@Nonnull PostgreSqlClusterWrapper.PostgreSqlClusterBuilder builder) {
        HashMap<String, String> envVarsMap = new HashMap<String, String>();
        envVarsMap.put("POSTGRESQL_POSTGRES_PASSWORD", "adminpassword");
        envVarsMap.put("POSTGRESQL_USERNAME", builder.getUsername());
        envVarsMap.put("POSTGRESQL_PASSWORD", builder.getPassword());
        envVarsMap.put("POSTGRESQL_DATABASE", builder.getDatabaseName());
        envVarsMap.put("REPMGR_PASSWORD", "repmgrpassword");
        envVarsMap.put("REPMGR_PRIMARY_HOST", this.primaryAlias);
        envVarsMap.put("REPMGR_PRIMARY_PORT", "5432");
        envVarsMap.put("REPMGR_PARTNER_NODES", String.format("%s,%s:5432", this.primaryAlias, this.standbyAlias));
        envVarsMap.put("REPMGR_PORT_NUMBER", "5432");
        envVarsMap.put("REPMGR_CONNECT_TIMEOUT", "1");
        envVarsMap.put("REPMGR_RECONNECT_ATTEMPTS", "1");
        envVarsMap.put("REPMGR_RECONNECT_INTERVAL", "1");
        return envVarsMap;
    }
}

