/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.testing;

import io.github.mfvanek.pg.model.MemoryUnit;
import io.github.mfvanek.pg.settings.ImportantParam;
import io.github.mfvanek.pg.testing.PostgreSqlDataSourceHelper;
import io.github.mfvanek.pg.testing.PostgresVersionAware;
import io.github.mfvanek.pg.testing.PostgresVersionHolder;
import io.github.mfvanek.pg.testing.annotations.ExcludeFromJacocoGeneratedReport;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public final class PostgreSqlContainerWrapper
implements AutoCloseable,
PostgresVersionAware {
    private final PostgresVersionHolder pgVersion;
    private final PostgreSQLContainer<?> container;
    private final BasicDataSource dataSource;

    PostgreSqlContainerWrapper(@Nonnull PostgresVersionHolder pgVersion, @Nonnull List<Map.Entry<String, String>> additionalParameters) {
        this.pgVersion = Objects.requireNonNull(pgVersion, "pgVersion cannot be null");
        this.container = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres").withTag(pgVersion.getVersion())).withSharedMemorySize(Long.valueOf(MemoryUnit.MB.convertToBytes(512)))).withTmpFs(Map.of("/var/lib/postgresql/data", "rw"))).withCommand(PostgreSqlContainerWrapper.prepareCommandParts(additionalParameters))).waitingFor(Wait.defaultWaitStrategy());
        this.container.start();
        this.dataSource = PostgreSqlDataSourceHelper.buildDataSource(this.container);
    }

    PostgreSqlContainerWrapper(@Nonnull PostgresVersionHolder pgVersion) {
        this(pgVersion, List.of(Map.entry(ImportantParam.LOCK_TIMEOUT.getName(), "1000"), Map.entry(ImportantParam.SHARED_BUFFERS.getName(), "256MB"), Map.entry(ImportantParam.MAINTENANCE_WORK_MEM.getName(), "128MB"), Map.entry(ImportantParam.WORK_MEM.getName(), "16MB"), Map.entry(ImportantParam.RANDOM_PAGE_COST.getName(), "1")));
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void close() {
        try {
            this.dataSource.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.container.close();
    }

    @Nonnull
    private static String[] prepareCommandParts(@Nonnull List<Map.Entry<String, String>> additionalParameters) {
        return (String[])additionalParameters.stream().flatMap(kv -> Stream.of("-c", (String)kv.getKey() + "=" + (String)kv.getValue())).toArray(String[]::new);
    }

    @Nonnull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getPort() {
        return this.container.getFirstMappedPort();
    }

    @Nonnull
    public String getUrl() {
        return this.container.getJdbcUrl();
    }

    @Nonnull
    public String getUsername() {
        return this.container.getUsername();
    }

    @Nonnull
    public String getPassword() {
        return this.container.getPassword();
    }

    @Override
    public boolean isCumulativeStatisticsSystemSupported() {
        return this.pgVersion.isCumulativeStatisticsSystemSupported();
    }

    @Override
    public boolean isProceduresSupported() {
        return this.pgVersion.isProceduresSupported();
    }

    @Override
    public boolean isOutParametersInProcedureSupported() {
        return this.pgVersion.isOutParametersInProcedureSupported();
    }

    @Nonnull
    public static PostgreSqlContainerWrapper withDefaultVersion() {
        return new PostgreSqlContainerWrapper(PostgresVersionHolder.forSingleNode());
    }

    @Nonnull
    public static PostgreSqlContainerWrapper withVersion(@Nonnull String pgVersion) {
        return new PostgreSqlContainerWrapper(PostgresVersionHolder.forSingleNode(pgVersion));
    }
}

