/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.testing;

import java.util.Map;
import java.util.Objects;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

class PostgresBitnamiRepmgrContainer
extends JdbcDatabaseContainer<PostgresBitnamiRepmgrContainer> {
    public static final Integer POSTGRESQL_PORT = 5432;
    private final Map<String, String> envVars;

    PostgresBitnamiRepmgrContainer(DockerImageName dockerImageName, Map<String, String> envVars) {
        super(dockerImageName);
        this.envVars = Map.copyOf(envVars);
        this.addExposedPort(POSTGRESQL_PORT);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/" + this.envVars.get("POSTGRESQL_DATABASE") + additionalUrlParams;
    }

    public String getUsername() {
        return this.envVars.get("POSTGRESQL_USERNAME");
    }

    public String getPassword() {
        return this.envVars.get("POSTGRESQL_PASSWORD");
    }

    protected String getTestQueryString() {
        return "SELECT 1";
    }

    protected void configure() {
        super.configure();
        this.envVars.forEach((arg_0, arg_1) -> ((PostgresBitnamiRepmgrContainer)this).addEnv(arg_0, arg_1));
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PostgresBitnamiRepmgrContainer)) {
            return false;
        }
        PostgresBitnamiRepmgrContainer that = (PostgresBitnamiRepmgrContainer)((Object)other);
        return Objects.equals(this.envVars, that.envVars);
    }

    public int hashCode() {
        return Objects.hash(System.identityHashCode((Object)this), this.envVars);
    }
}

