/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.testing;

import io.github.mfvanek.pg.testing.PostgresVersionAware;
import io.github.mfvanek.pg.testing.annotations.ExcludeFromJacocoGeneratedReport;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class PostgresVersionHolder
implements PostgresVersionAware {
    private final String pgVersion;

    PostgresVersionHolder(@Nonnull String pgVersion) {
        this.pgVersion = Objects.requireNonNull(pgVersion, "pgVersion cannot be null");
    }

    private int getMajorVersion() {
        String[] parts = this.pgVersion.split("\\.");
        return Integer.parseInt(parts[0]);
    }

    @Nonnull
    public String getVersion() {
        return this.pgVersion;
    }

    @Override
    public boolean isCumulativeStatisticsSystemSupported() {
        return this.getMajorVersion() >= 15;
    }

    @Override
    public boolean isProceduresSupported() {
        return this.getMajorVersion() >= 11;
    }

    @Override
    public boolean isOutParametersInProcedureSupported() {
        return this.isProceduresSupported() && this.getMajorVersion() >= 14;
    }

    @ExcludeFromJacocoGeneratedReport
    @Nonnull
    private static String preparePostgresVersion() {
        String pgVersion = System.getenv("TEST_PG_VERSION");
        if (pgVersion != null) {
            return pgVersion;
        }
        return "16.0";
    }

    @Nonnull
    static String toBitnamiVersion(@Nonnull String pgVersion) {
        int index = pgVersion.indexOf(45);
        String bitnamiVersion = index == -1 ? pgVersion : pgVersion.substring(0, index);
        return bitnamiVersion + ".0";
    }

    @Nonnull
    static PostgresVersionHolder forCluster() {
        return new PostgresVersionHolder(PostgresVersionHolder.toBitnamiVersion(PostgresVersionHolder.preparePostgresVersion()));
    }

    @Nonnull
    static PostgresVersionHolder forCluster(@Nonnull String pgVersion) {
        return new PostgresVersionHolder(PostgresVersionHolder.toBitnamiVersion(pgVersion));
    }

    @Nonnull
    static PostgresVersionHolder forSingleNode() {
        return new PostgresVersionHolder(PostgresVersionHolder.preparePostgresVersion());
    }

    @Nonnull
    static PostgresVersionHolder forSingleNode(@Nonnull String pgVersion) {
        return new PostgresVersionHolder(pgVersion);
    }
}

