/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.testing;

import io.github.mfvanek.pg.model.MemoryUnit;
import io.github.mfvanek.pg.testing.PostgreSqlClusterAliasHolder;
import io.github.mfvanek.pg.testing.PostgreSqlDataSourceHelper;
import io.github.mfvanek.pg.testing.PostgresBitnamiRepmgrContainer;
import io.github.mfvanek.pg.testing.PostgresVersionHolder;
import io.github.mfvanek.pg.testing.annotations.ExcludeFromJacocoGeneratedReport;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public final class PostgreSqlClusterWrapper
implements AutoCloseable {
    public static final Duration WAIT_INTERVAL_SECONDS = Duration.ofSeconds(100L);
    private static final String IMAGE_NAME = "docker.io/bitnami/postgresql-repmgr";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSqlClusterWrapper.class);
    private final PostgresVersionHolder pgVersion;
    private final Network network;
    private final JdbcDatabaseContainer<PostgresBitnamiRepmgrContainer> containerForPrimary;
    private final JdbcDatabaseContainer<PostgresBitnamiRepmgrContainer> containerForStandBy;
    private final BasicDataSource dataSourceForPrimary;
    private final BasicDataSource dataSourceForStandBy;

    private PostgreSqlClusterWrapper(@Nonnull PostgreSqlClusterBuilder builder) {
        this.pgVersion = builder.getPostgresVersion() != null ? PostgresVersionHolder.forCluster(builder.getPostgresVersion()) : PostgresVersionHolder.forCluster();
        this.network = Network.newNetwork();
        PostgreSqlClusterAliasHolder aliases = new PostgreSqlClusterAliasHolder();
        this.containerForPrimary = this.createContainerAndInitWith(aliases.createPrimaryEnvVarsMap(builder), aliases.getPrimaryAlias(), aliases.getWaitStrategyForPrimary());
        this.containerForStandBy = this.createContainerAndInitWith(aliases.createStandbyEnvVarsMap(builder), aliases.getStandbyAlias(), aliases.getWaitStrategyForStandBy());
        this.containerForPrimary.start();
        Awaitility.await((String)"Ensure primary is ready").atMost(PostgreSqlClusterAliasHolder.STARTUP_TIMEOUT).pollInterval(Duration.ofSeconds(1L)).until(() -> this.containerForPrimary.getLogs().contains("database system is ready to accept connections"));
        this.containerForStandBy.start();
        Awaitility.await((String)"Ensure cluster is ready").atMost(PostgreSqlClusterAliasHolder.STARTUP_TIMEOUT).pollInterval(Duration.ofSeconds(1L)).until(() -> this.containerForStandBy.getLogs().contains("started streaming WAL from primary"));
        this.dataSourceForPrimary = PostgreSqlDataSourceHelper.buildDataSource(this.containerForPrimary);
        this.dataSourceForStandBy = PostgreSqlDataSourceHelper.buildDataSource(this.containerForStandBy);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void close() {
        try {
            this.dataSourceForStandBy.close();
        }
        catch (SQLException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
        }
        try {
            this.dataSourceForPrimary.close();
        }
        catch (SQLException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
        }
        this.containerForStandBy.close();
        this.containerForPrimary.close();
    }

    @Nonnull
    public DataSource getDataSourceForPrimary() {
        this.throwErrorIfNotInitialized();
        return this.dataSourceForPrimary;
    }

    @Nonnull
    public DataSource getDataSourceForStandBy() {
        this.throwErrorIfNotInitialized();
        return this.dataSourceForStandBy;
    }

    @Nonnull
    public String getFirstContainerJdbcUrl() {
        this.throwErrorIfNotInitialized();
        return this.containerForPrimary.getJdbcUrl();
    }

    @Nonnull
    public String getSecondContainerJdbcUrl() {
        this.throwErrorIfNotInitialized();
        return this.containerForStandBy.getJdbcUrl();
    }

    @Nonnull
    public String getUsername() {
        return this.containerForPrimary.getUsername();
    }

    @Nonnull
    public String getPassword() {
        return this.containerForPrimary.getPassword();
    }

    public boolean stopFirstContainer() {
        this.containerForPrimary.stop();
        LOGGER.info("Waiting for standby will be promoted to primary");
        Awaitility.await((String)"Promoting standby to primary").atMost(WAIT_INTERVAL_SECONDS).pollInterval(Duration.ofSeconds(1L)).until(() -> this.containerForStandBy.getLogs().contains("promoting standby to primary"));
        Awaitility.await((String)"Standby promoted to primary").atMost(WAIT_INTERVAL_SECONDS).pollInterval(Duration.ofSeconds(1L)).until(() -> this.containerForStandBy.getLogs().contains("standby promoted to primary after"));
        return true;
    }

    @Nonnull
    private PostgresBitnamiRepmgrContainer createContainerAndInitWith(Map<String, String> envVars, String alias, WaitStrategy waitStrategy) {
        DockerImageName dockerImageName = DockerImageName.parse((String)IMAGE_NAME).withTag(this.pgVersion.getVersion());
        return (PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)((PostgresBitnamiRepmgrContainer)new PostgresBitnamiRepmgrContainer(dockerImageName, envVars).withCreateContainerCmdModifier(cmd -> cmd.withName(alias))).withSharedMemorySize(MemoryUnit.MB.convertToBytes(768))).withTmpFs(Map.of("/var/lib/postgresql/data", "rw"))).withNetwork(this.network)).withNetworkAliases(new String[]{alias})).withExposedPorts(new Integer[]{5432})).waitingFor(waitStrategy);
    }

    @ExcludeFromJacocoGeneratedReport
    private void throwErrorIfNotInitialized() {
        if (this.containerForPrimary == null || this.dataSourceForPrimary == null || this.containerForStandBy == null || this.dataSourceForStandBy == null) {
            throw new AssertionError((Object)"not initialized");
        }
    }

    @Nonnull
    public static PostgreSqlClusterBuilder builder() {
        return new PostgreSqlClusterBuilder();
    }

    public static class PostgreSqlClusterBuilder {
        private String username = "customuser";
        private String password = "custompassword";
        private String databaseName = "customdatabase";
        private String postgresVersion;

        private PostgreSqlClusterBuilder() {
        }

        @Nonnull
        public String getUsername() {
            return this.username;
        }

        @Nonnull
        public String getPassword() {
            return this.password;
        }

        @Nonnull
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Nullable
        public String getPostgresVersion() {
            return this.postgresVersion;
        }

        @Nonnull
        public PostgreSqlClusterBuilder withUsername(@Nonnull String username) {
            this.username = Objects.requireNonNull(username, "username cannot be null");
            return this;
        }

        @Nonnull
        public PostgreSqlClusterBuilder withPassword(@Nonnull String password) {
            this.password = Objects.requireNonNull(password, "password cannot be null");
            return this;
        }

        @Nonnull
        public PostgreSqlClusterBuilder withDatabaseName(@Nonnull String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName cannot be null");
            return this;
        }

        @Nonnull
        public PostgreSqlClusterBuilder withPostgresVersion(@Nonnull String postgresVersion) {
            this.postgresVersion = Objects.requireNonNull(postgresVersion, "postgresVersion cannot be null");
            return this;
        }

        @Nonnull
        public PostgreSqlClusterWrapper build() {
            return new PostgreSqlClusterWrapper(this);
        }
    }
}

