/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.common.maintenance.DatabaseCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.common.maintenance.ResultSetExtractor;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.utils.SqlQueryReader;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

abstract class AbstractCheckOnHost<T extends DbObject>
implements DatabaseCheckOnHost<T> {
    protected static final String TABLE_NAME = "table_name";
    protected static final String INDEX_NAME = "index_name";
    protected static final String TABLE_SIZE = "table_size";
    protected static final String INDEX_SIZE = "index_size";
    protected static final String BLOAT_SIZE = "bloat_size";
    protected static final String BLOAT_PERCENTAGE = "bloat_percentage";
    private final Class<T> type;
    private final PgConnection pgConnection;
    private final Diagnostic diagnostic;

    protected AbstractCheckOnHost(@Nonnull Class<T> type, @Nonnull PgConnection pgConnection, @Nonnull Diagnostic diagnostic) {
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.pgConnection = Objects.requireNonNull(pgConnection, "pgConnection cannot be null");
        this.diagnostic = Objects.requireNonNull(diagnostic, "diagnostic cannot be null");
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    @Nonnull
    public PgHost getHost() {
        return this.pgConnection.getHost();
    }

    @Nonnull
    protected List<T> executeQuery(@Nonnull PgContext pgContext, @Nonnull ResultSetExtractor<T> rse) {
        String sqlQuery = SqlQueryReader.getQueryFromFile(this.diagnostic.getSqlQueryFileName());
        return this.diagnostic.getQueryExecutor().executeQuery(this.pgConnection, pgContext, sqlQuery, rse);
    }
}

