/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.index.DuplicatedIndexes;
import java.util.List;
import javax.annotation.Nonnull;

public class DuplicatedIndexesCheckOnHost
extends AbstractCheckOnHost<DuplicatedIndexes> {
    public DuplicatedIndexesCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(DuplicatedIndexes.class, pgConnection, Diagnostic.DUPLICATED_INDEXES);
    }

    @Override
    @Nonnull
    public List<DuplicatedIndexes> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String duplicatedAsString = rs.getString("duplicated_indexes");
            return DuplicatedIndexes.of((String)tableName, (String)duplicatedAsString);
        });
    }
}

