/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.function.StoredFunction;
import java.util.List;
import javax.annotation.Nonnull;

public class FunctionsWithoutDescriptionCheckOnHost
extends AbstractCheckOnHost<StoredFunction> {
    public FunctionsWithoutDescriptionCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(StoredFunction.class, pgConnection, Diagnostic.FUNCTIONS_WITHOUT_DESCRIPTION);
    }

    @Override
    @Nonnull
    public List<StoredFunction> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String functionName = rs.getString("function_name");
            String functionSignature = rs.getString("function_signature");
            return StoredFunction.of((String)functionName, (String)functionSignature);
        });
    }
}

