/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.index.IndexWithBloat;
import java.util.List;
import javax.annotation.Nonnull;

public class IndexesWithBloatCheckOnHost
extends AbstractCheckOnHost<IndexWithBloat> {
    public IndexesWithBloatCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(IndexWithBloat.class, pgConnection, Diagnostic.BLOATED_INDEXES);
    }

    @Override
    @Nonnull
    public List<IndexWithBloat> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String indexName = rs.getString("index_name");
            long indexSize = rs.getLong("index_size");
            long bloatSize = rs.getLong("bloat_size");
            int bloatPercentage = rs.getInt("bloat_percentage");
            return IndexWithBloat.of((String)tableName, (String)indexName, (long)indexSize, (long)bloatSize, (int)bloatPercentage);
        });
    }
}

