/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.index.Index;
import java.util.List;
import javax.annotation.Nonnull;

public class InvalidIndexesCheckOnHost
extends AbstractCheckOnHost<Index> {
    public InvalidIndexesCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(Index.class, pgConnection, Diagnostic.INVALID_INDEXES);
    }

    @Override
    @Nonnull
    public List<Index> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String indexName = rs.getString("index_name");
            return Index.of((String)tableName, (String)indexName);
        });
    }
}

