/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.index.UnusedIndex;
import java.util.List;
import javax.annotation.Nonnull;

public class UnusedIndexesCheckOnHost
extends AbstractCheckOnHost<UnusedIndex> {
    public UnusedIndexesCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(UnusedIndex.class, pgConnection, Diagnostic.UNUSED_INDEXES);
    }

    @Override
    @Nonnull
    public List<UnusedIndex> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String indexName = rs.getString("index_name");
            long indexSize = rs.getLong("index_size");
            long indexScans = rs.getLong("index_scans");
            return UnusedIndex.of((String)tableName, (String)indexName, (long)indexSize, (long)indexScans);
        });
    }
}

