/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.predicates;

import io.github.mfvanek.pg.model.BloatAware;
import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.validation.AdditionalValidators;
import javax.annotation.Nonnull;

abstract class AbstractFilterByBloat {
    private final long sizeThresholdInBytes;
    private final int percentageThreshold;

    protected AbstractFilterByBloat(long sizeThresholdInBytes, int percentageThreshold) {
        this.sizeThresholdInBytes = Validators.sizeNotNegative((long)sizeThresholdInBytes, (String)"sizeThresholdInBytes");
        this.percentageThreshold = AdditionalValidators.validPercent(percentageThreshold, "percentageThreshold");
    }

    protected boolean isOk(@Nonnull BloatAware bloatAware) {
        return bloatAware.getBloatSizeInBytes() >= this.sizeThresholdInBytes && bloatAware.getBloatPercentage() >= this.percentageThreshold;
    }
}

