/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.health.logger;

import io.github.mfvanek.pg.common.health.logger.AbstractHealthLogger;
import io.github.mfvanek.pg.common.health.logger.LoggingKey;
import io.github.mfvanek.pg.common.maintenance.DatabaseChecks;
import io.github.mfvanek.pg.connection.ConnectionCredentials;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnectionFactory;
import io.github.mfvanek.pg.utils.ClockHolder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueFileHealthLogger
extends AbstractHealthLogger {
    private static final Logger KV_LOG = LoggerFactory.getLogger((String)"key-value.log");

    public KeyValueFileHealthLogger(@Nonnull ConnectionCredentials credentials, @Nonnull HighAvailabilityPgConnectionFactory connectionFactory, @Nonnull Function<HighAvailabilityPgConnection, DatabaseChecks> databaseChecksFactory) {
        super(credentials, connectionFactory, databaseChecksFactory);
    }

    @Override
    protected String writeToLog(@Nonnull LoggingKey key, int value) {
        String result = this.format(key.getKeyName(), key.getSubKeyName(), value);
        KV_LOG.info(result);
        return result;
    }

    @Nonnull
    private String format(@Nonnull String keyName, @Nonnull String subKeyName, int value) {
        return DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now(ClockHolder.clock())) + "\t" + keyName + "\t" + subKeyName + "\t" + value;
    }
}

