/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.maintenance;

import io.github.mfvanek.pg.checks.cluster.ColumnsWithJsonTypeCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.ColumnsWithSerialTypesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.ColumnsWithoutDescriptionCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.DuplicatedIndexesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.ForeignKeysNotCoveredWithIndexCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.FunctionsWithoutDescriptionCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.IndexesWithBloatCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.IndexesWithNullValuesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.IntersectedIndexesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.InvalidIndexesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.TablesWithBloatCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.TablesWithMissingIndexesCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.TablesWithoutDescriptionCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.TablesWithoutPrimaryKeyCheckOnCluster;
import io.github.mfvanek.pg.checks.cluster.UnusedIndexesCheckOnCluster;
import io.github.mfvanek.pg.common.maintenance.DatabaseCheckOnCluster;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.model.DbObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DatabaseChecks {
    private final ConcurrentMap<Diagnostic, DatabaseCheckOnCluster<? extends DbObject>> checks = new ConcurrentHashMap<Diagnostic, DatabaseCheckOnCluster<? extends DbObject>>();

    public DatabaseChecks(@Nonnull HighAvailabilityPgConnection haPgConnection) {
        Stream<DatabaseCheckOnCluster> allChecks = Stream.of(new TablesWithBloatCheckOnCluster(haPgConnection), new TablesWithMissingIndexesCheckOnCluster(haPgConnection), new TablesWithoutPrimaryKeyCheckOnCluster(haPgConnection), new DuplicatedIndexesCheckOnCluster(haPgConnection), new ForeignKeysNotCoveredWithIndexCheckOnCluster(haPgConnection), new IndexesWithBloatCheckOnCluster(haPgConnection), new IndexesWithNullValuesCheckOnCluster(haPgConnection), new IntersectedIndexesCheckOnCluster(haPgConnection), new InvalidIndexesCheckOnCluster(haPgConnection), new UnusedIndexesCheckOnCluster(haPgConnection), new TablesWithoutDescriptionCheckOnCluster(haPgConnection), new ColumnsWithoutDescriptionCheckOnCluster(haPgConnection), new ColumnsWithJsonTypeCheckOnCluster(haPgConnection), new ColumnsWithSerialTypesCheckOnCluster(haPgConnection), new FunctionsWithoutDescriptionCheckOnCluster(haPgConnection));
        allChecks.forEach(check -> this.checks.putIfAbsent(check.getDiagnostic(), (DatabaseCheckOnCluster<? extends DbObject>)check));
    }

    @Nonnull
    public <T extends DbObject> DatabaseCheckOnCluster<T> getCheck(@Nonnull Diagnostic diagnostic, @Nonnull Class<T> type) {
        DatabaseCheckOnCluster check = (DatabaseCheckOnCluster)this.checks.get((Object)diagnostic);
        if (check == null) {
            throw new IllegalStateException(String.format("Check for diagnostic %s not found", new Object[]{diagnostic}));
        }
        if (!type.isAssignableFrom(check.getType())) {
            throw new IllegalArgumentException("Illegal type: " + type);
        }
        return check;
    }
}

