/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.statistics.maintenance;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.statistics.maintenance.StatisticsMaintenanceOnHost;
import io.github.mfvanek.pg.statistics.maintenance.StatisticsQueryExecutor;
import io.github.mfvanek.pg.utils.QueryExecutors;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class StatisticsMaintenanceOnHostImpl
implements StatisticsMaintenanceOnHost {
    private final PgConnection pgConnection;
    private final StatisticsQueryExecutor queryExecutor;

    StatisticsMaintenanceOnHostImpl(@Nonnull PgConnection pgConnection, @Nonnull StatisticsQueryExecutor queryExecutor) {
        this.pgConnection = Objects.requireNonNull(pgConnection, "pgConnection cannot be null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor cannot be null");
    }

    public StatisticsMaintenanceOnHostImpl(@Nonnull PgConnection pgConnection) {
        this(pgConnection, QueryExecutors::executeQuery);
    }

    @Nonnull
    public PgHost getHost() {
        return this.pgConnection.getHost();
    }

    @Override
    public boolean resetStatistics() {
        List<Boolean> result = this.queryExecutor.executeQuery(this.pgConnection, "select pg_stat_reset()", rs -> true);
        return !result.isEmpty() && result.get(0) != false;
    }

    @Override
    @Nonnull
    public Optional<OffsetDateTime> getLastStatsResetTimestamp() {
        String query = "select stats_reset from pg_stat_database where datname = current_database()";
        List<OffsetDateTime> statsResetTimes = this.queryExecutor.executeQuery(this.pgConnection, "select stats_reset from pg_stat_database where datname = current_database()", rs -> rs.getObject(1, OffsetDateTime.class));
        return Optional.ofNullable(statsResetTimes.get(0));
    }
}

