/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClockHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClockHolder.class);
    private static final AtomicReference<Clock> CLOCK_REFERENCE = new AtomicReference<Clock>(Clock.systemUTC());

    private ClockHolder() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static Clock clock() {
        return CLOCK_REFERENCE.get();
    }

    @Nonnull
    public static Clock setClock(@Nonnull Clock newClock) {
        Objects.requireNonNull(newClock, "newClock cannot be null");
        Clock oldClock = CLOCK_REFERENCE.getAndSet(newClock);
        LOGGER.debug("Set new clock {}. Old clock was {}", (Object)newClock, (Object)oldClock);
        return oldClock;
    }
}

