/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.validation.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ColumnsInForeignKeyParser {
    private ColumnsInForeignKeyParser() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static List<Column> parseRawColumnData(@Nonnull String tableName, String ... rawColumns) {
        Validators.tableNameNotBlank((String)tableName);
        Objects.requireNonNull(rawColumns, "rawColumns cannot be null");
        if (rawColumns.length == 0) {
            throw new IllegalArgumentException("Columns array cannot be empty");
        }
        return Arrays.stream(rawColumns).map(c -> ColumnsInForeignKeyParser.toColumn(tableName, c)).collect(Collectors.toUnmodifiableList());
    }

    @Nonnull
    private static Column toColumn(@Nonnull String tableName, @Nonnull String rawColumnInfo) {
        String[] columnInfo = rawColumnInfo.split(", ");
        if (columnInfo.length != 2) {
            throw new IllegalArgumentException("Cannot parse column info from " + rawColumnInfo);
        }
        boolean notNullColumn = Boolean.parseBoolean(columnInfo[1]);
        if (notNullColumn) {
            return Column.ofNotNull((String)tableName, (String)columnInfo[0]);
        }
        return Column.ofNullable((String)tableName, (String)columnInfo[0]);
    }
}

