/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import io.github.mfvanek.pg.common.maintenance.ResultSetExtractor;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgSqlException;
import io.github.mfvanek.pg.model.PgContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutors {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExecutors.class);

    private QueryExecutors() {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static <T> List<T> executeQuery(@Nonnull PgConnection pgConnection, @Nonnull String sqlQuery, @Nonnull ResultSetExtractor<T> rse) {
        LOGGER.debug("Executing query: {}", (Object)sqlQuery);
        Objects.requireNonNull(sqlQuery, "sqlQuery cannot be null");
        DataSource dataSource = pgConnection.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            ArrayList<T> arrayList;
            block22: {
                Statement statement = connection.createStatement();
                try {
                    ArrayList<T> executionResult = new ArrayList<T>();
                    try (ResultSet resultSet = statement.executeQuery(sqlQuery);){
                        while (resultSet.next()) {
                            executionResult.add(rse.extractData(resultSet));
                        }
                    }
                    LOGGER.debug("Query completed with result {}", executionResult);
                    arrayList = executionResult;
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new PgSqlException(e);
        }
    }

    @Nonnull
    public static <T> List<T> executeQueryWithSchema(@Nonnull PgConnection pgConnection, @Nonnull PgContext pgContext, @Nonnull String sqlQuery, @Nonnull ResultSetExtractor<T> rse) {
        return QueryExecutors.executeQuery(pgConnection, pgContext, sqlQuery, rse, statement -> {
            try {
                statement.setString(1, pgContext.getSchemaName());
            }
            catch (SQLException e) {
                throw new PgSqlException(e);
            }
        });
    }

    @Nonnull
    public static <T> List<T> executeQueryWithBloatThreshold(@Nonnull PgConnection pgConnection, @Nonnull PgContext pgContext, @Nonnull String sqlQuery, @Nonnull ResultSetExtractor<T> rse) {
        return QueryExecutors.executeQuery(pgConnection, pgContext, sqlQuery, rse, statement -> {
            try {
                statement.setString(1, pgContext.getSchemaName());
                statement.setInt(2, pgContext.getBloatPercentageThreshold());
            }
            catch (SQLException e) {
                throw new PgSqlException(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static <T> List<T> executeQuery(@Nonnull PgConnection pgConnection, @Nonnull PgContext pgContext, @Nonnull String sqlQuery, @Nonnull ResultSetExtractor<T> rse, @Nonnull Consumer<PreparedStatement> paramsSetter) {
        LOGGER.debug("Executing query with context {}: {}", (Object)pgContext, (Object)sqlQuery);
        Objects.requireNonNull(sqlQuery, "sqlQuery");
        DataSource dataSource = pgConnection.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            ArrayList<T> arrayList;
            block22: {
                PreparedStatement statement = connection.prepareStatement(sqlQuery);
                try {
                    paramsSetter.accept(statement);
                    ArrayList<T> executionResult = new ArrayList<T>();
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            executionResult.add(rse.extractData(resultSet));
                        }
                    }
                    LOGGER.debug("Query completed with result {}", executionResult);
                    arrayList = executionResult;
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw new PgSqlException(e);
        }
    }
}

