/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.constraint.ForeignKey;
import io.github.mfvanek.pg.utils.ColumnsInForeignKeyParser;
import java.sql.Array;
import java.util.List;
import javax.annotation.Nonnull;

public class ForeignKeysNotCoveredWithIndexCheckOnHost
extends AbstractCheckOnHost<ForeignKey> {
    public ForeignKeysNotCoveredWithIndexCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(ForeignKey.class, pgConnection, Diagnostic.FOREIGN_KEYS_WITHOUT_INDEX);
    }

    @Override
    @Nonnull
    public List<ForeignKey> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String constraintName = rs.getString("constraint_name");
            Array columnsArray = rs.getArray("columns");
            String[] rawColumns = (String[])columnsArray.getArray();
            List<Column> columns = ColumnsInForeignKeyParser.parseRawColumnData(tableName, rawColumns);
            return ForeignKey.of((String)tableName, (String)constraintName, columns);
        });
    }
}

