/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.table.TableWithMissingIndex;
import java.util.List;
import javax.annotation.Nonnull;

public class TablesWithMissingIndexesCheckOnHost
extends AbstractCheckOnHost<TableWithMissingIndex> {
    public TablesWithMissingIndexesCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(TableWithMissingIndex.class, pgConnection, Diagnostic.TABLES_WITH_MISSING_INDEXES);
    }

    @Override
    @Nonnull
    public List<TableWithMissingIndex> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            long tableSize = rs.getLong("table_size");
            long seqScans = rs.getLong("seq_scan");
            long indexScans = rs.getLong("idx_scan");
            return TableWithMissingIndex.of((String)tableName, (long)tableSize, (long)seqScans, (long)indexScans);
        });
    }
}

