/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.maintenance;

import io.github.mfvanek.pg.common.maintenance.DiagnosticAware;
import io.github.mfvanek.pg.common.maintenance.RawTypeAware;
import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.PgContext;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public interface DatabaseCheckOnCluster<T extends DbObject>
extends DiagnosticAware,
RawTypeAware<T> {
    @Nonnull
    public List<T> check(@Nonnull PgContext var1, @Nonnull Predicate<? super T> var2);

    @Nonnull
    default public List<T> check(@Nonnull PgContext pgContext) {
        return this.check(pgContext, (? super T item) -> true);
    }

    @Nonnull
    default public List<T> check() {
        return this.check(PgContext.ofPublic(), (? super T item) -> true);
    }

    @Nonnull
    default public List<T> check(@Nonnull Collection<? extends PgContext> pgContexts, @Nonnull Predicate<? super T> exclusionsFilter) {
        return pgContexts.stream().map(ctx -> this.check((PgContext)ctx, exclusionsFilter)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

