/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.cluster;

import io.github.mfvanek.pg.checks.cluster.AbstractCheckOnCluster;
import io.github.mfvanek.pg.checks.host.UnusedIndexesCheckOnHost;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.model.index.UnusedIndex;
import io.github.mfvanek.pg.statistics.maintenance.StatisticsMaintenanceOnHost;
import io.github.mfvanek.pg.statistics.maintenance.StatisticsMaintenanceOnHostImpl;
import io.github.mfvanek.pg.utils.ClockHolder;
import io.github.mfvanek.pg.utils.CollectionUtils;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedIndexesCheckOnCluster
extends AbstractCheckOnCluster<UnusedIndex> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedIndexesCheckOnCluster.class);
    private final Function<PgConnection, StatisticsMaintenanceOnHost> statisticsOnHostFactory = StatisticsMaintenanceOnHostImpl::new;
    private final Map<PgHost, StatisticsMaintenanceOnHost> statistics = new HashMap<PgHost, StatisticsMaintenanceOnHost>();

    public UnusedIndexesCheckOnCluster(@Nonnull HighAvailabilityPgConnection haPgConnection) {
        super(haPgConnection, UnusedIndexesCheckOnHost::new, UnusedIndexesCheckOnCluster::getResultAsIntersection);
    }

    @Override
    protected void doBeforeExecuteOnHost(@Nonnull PgConnection connectionToHost) {
        this.logLastStatsResetDate(connectionToHost);
        super.doBeforeExecuteOnHost(connectionToHost);
    }

    private void logLastStatsResetDate(@Nonnull PgConnection connectionToHost) {
        String resetDateLogMessage = UnusedIndexesCheckOnCluster.getLastStatsResetDateLogMessage(this.computeStatisticsForHostIfNeed(connectionToHost));
        LOGGER.info("{}", (Object)resetDateLogMessage);
    }

    @Nonnull
    static List<UnusedIndex> getResultAsIntersection(@Nonnull List<List<UnusedIndex>> potentiallyUnusedIndexesFromAllHosts) {
        LOGGER.debug("potentiallyUnusedIndexesFromAllHosts = {}", potentiallyUnusedIndexesFromAllHosts);
        Collection<UnusedIndex> unusedIndexes = null;
        for (List<UnusedIndex> unusedIndexesFromHost : potentiallyUnusedIndexesFromAllHosts) {
            if (unusedIndexes == null) {
                unusedIndexes = unusedIndexesFromHost;
                continue;
            }
            unusedIndexes = CollectionUtils.intersection(unusedIndexes, unusedIndexesFromHost);
        }
        List<UnusedIndex> result = unusedIndexes == null ? List.of() : List.copyOf(unusedIndexes);
        LOGGER.debug("Intersection result {}", result);
        return result;
    }

    @Nonnull
    static String getLastStatsResetDateLogMessage(@Nonnull StatisticsMaintenanceOnHost statisticsMaintenance) {
        Objects.requireNonNull(statisticsMaintenance, "statisticsMaintenance cannot be null");
        Optional statsResetTimestamp = statisticsMaintenance.getLastStatsResetTimestamp();
        if (statsResetTimestamp.isPresent()) {
            long daysBetween = ChronoUnit.DAYS.between((Temporal)statsResetTimestamp.get(), OffsetDateTime.now(ClockHolder.clock()));
            return String.format(Locale.ROOT, "Last statistics reset on this host was %d days ago (%s)", daysBetween, statsResetTimestamp.get());
        }
        return "Statistics have never been reset on this host";
    }

    @Nonnull
    private StatisticsMaintenanceOnHost computeStatisticsForHostIfNeed(@Nonnull PgConnection connectionToHost) {
        return this.statistics.computeIfAbsent(connectionToHost.getHost(), h -> this.statisticsOnHostFactory.apply(connectionToHost));
    }
}

