/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.predicates;

import io.github.mfvanek.pg.model.BloatAware;
import io.github.mfvanek.pg.model.validation.Validators;
import javax.annotation.Nonnull;

abstract class AbstractFilterByBloat {
    private final long sizeThresholdInBytes;
    private final double percentageThreshold;

    protected AbstractFilterByBloat(long sizeThresholdInBytes, double percentageThreshold) {
        this.sizeThresholdInBytes = Validators.sizeNotNegative((long)sizeThresholdInBytes, (String)"sizeThresholdInBytes");
        this.percentageThreshold = Validators.validPercent((double)percentageThreshold, (String)"percentageThreshold");
    }

    protected boolean isOk(@Nonnull BloatAware bloatAware) {
        return bloatAware.getBloatSizeInBytes() >= this.sizeThresholdInBytes && bloatAware.getBloatPercentage() >= this.percentageThreshold;
    }
}

