/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.predicates;

import io.github.mfvanek.pg.checks.predicates.AbstractFilterByName;
import io.github.mfvanek.pg.model.index.DuplicatedIndexes;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FilterDuplicatedIndexesByNamePredicate
extends AbstractFilterByName
implements Predicate<DuplicatedIndexes> {
    private FilterDuplicatedIndexesByNamePredicate(@Nonnull Collection<String> exclusions) {
        super(exclusions);
    }

    private FilterDuplicatedIndexesByNamePredicate(@Nonnull String indexName) {
        super(indexName);
    }

    @Override
    public boolean test(@Nonnull DuplicatedIndexes duplicatedIndexes) {
        if (this.exclusions.isEmpty()) {
            return true;
        }
        return duplicatedIndexes.getIndexNames().stream().map(n -> n.toLowerCase(Locale.ROOT)).noneMatch(this.exclusions::contains);
    }

    @Nonnull
    public static Predicate<DuplicatedIndexes> of(@Nonnull Collection<String> exclusions) {
        return new FilterDuplicatedIndexesByNamePredicate(exclusions);
    }

    @Nonnull
    public static Predicate<DuplicatedIndexes> of(@Nonnull String indexName) {
        return new FilterDuplicatedIndexesByNamePredicate(indexName);
    }
}

