/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.management;

import io.github.mfvanek.pg.common.management.DatabaseManagement;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.settings.PgParam;
import io.github.mfvanek.pg.settings.ServerSpecification;
import io.github.mfvanek.pg.settings.maintenance.ConfigurationMaintenanceOnHost;
import io.github.mfvanek.pg.statistics.maintenance.StatisticsMaintenanceOnHost;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManagementImpl
implements DatabaseManagement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManagementImpl.class);
    private final HighAvailabilityPgConnection haPgConnection;
    private final Function<PgConnection, StatisticsMaintenanceOnHost> statisticsOnHostFactory;
    private final Function<PgConnection, ConfigurationMaintenanceOnHost> configurationOnHostFactory;
    private final Map<PgHost, StatisticsMaintenanceOnHost> statistics;
    private final Map<PgHost, ConfigurationMaintenanceOnHost> configuration;

    public DatabaseManagementImpl(@Nonnull HighAvailabilityPgConnection haPgConnection, @Nonnull Function<PgConnection, StatisticsMaintenanceOnHost> statisticsOnHostFactory, @Nonnull Function<PgConnection, ConfigurationMaintenanceOnHost> configurationOnHostFactory) {
        this.haPgConnection = Objects.requireNonNull(haPgConnection, "haPgConnection cannot be null");
        this.statisticsOnHostFactory = Objects.requireNonNull(statisticsOnHostFactory, "statisticsOnHostFactory cannot be null");
        this.configurationOnHostFactory = Objects.requireNonNull(configurationOnHostFactory, "configurationOnHostFactory cannot be null");
        this.statistics = new HashMap<PgHost, StatisticsMaintenanceOnHost>();
        this.configuration = new HashMap<PgHost, ConfigurationMaintenanceOnHost>();
    }

    @Override
    public boolean resetStatistics() {
        boolean result = true;
        for (PgConnection pgConnection : this.haPgConnection.getConnectionsToAllHostsInCluster()) {
            LOGGER.debug("Going to execute on host {}", (Object)pgConnection.getHost().getName());
            boolean resultOnHost = this.computeStatisticsForHostIfNeed(pgConnection).resetStatistics();
            result = result && resultOnHost;
        }
        return result;
    }

    @Override
    @Nonnull
    public Optional<OffsetDateTime> getLastStatsResetTimestamp() {
        return this.computeStatisticsForHostIfNeed(this.getPrimaryAngLog()).getLastStatsResetTimestamp();
    }

    @Nonnull
    public Set<PgParam> getParamsWithDefaultValues(@Nonnull ServerSpecification specification) {
        return this.computeConfigurationForHostIfNeed(this.getPrimaryAngLog()).getParamsWithDefaultValues(specification);
    }

    @Nonnull
    public Set<PgParam> getParamsCurrentValues() {
        return this.computeConfigurationForHostIfNeed(this.getPrimaryAngLog()).getParamsCurrentValues();
    }

    @Nonnull
    private PgConnection getPrimaryAngLog() {
        PgConnection connectionToPrimary = this.haPgConnection.getConnectionToPrimary();
        LOGGER.debug("Going to execute on primary host {}", (Object)connectionToPrimary.getHost().getName());
        return connectionToPrimary;
    }

    @Nonnull
    private StatisticsMaintenanceOnHost computeStatisticsForHostIfNeed(@Nonnull PgConnection connectionToHost) {
        return this.statistics.computeIfAbsent(connectionToHost.getHost(), h -> this.statisticsOnHostFactory.apply(connectionToHost));
    }

    @Nonnull
    private ConfigurationMaintenanceOnHost computeConfigurationForHostIfNeed(@Nonnull PgConnection connectionToHost) {
        return this.configuration.computeIfAbsent(connectionToHost.getHost(), h -> this.configurationOnHostFactory.apply(connectionToHost));
    }
}

