/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static <T> Collection<T> intersection(@Nonnull Collection<? extends T> first, @Nonnull Collection<? extends T> second) {
        Objects.requireNonNull(first, "first cannot be null");
        Set<T> prepared = Set.copyOf(Objects.requireNonNull(second, "second cannot be null"));
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T item : first) {
            if (!prepared.contains(item)) continue;
            result.add(item);
        }
        return result;
    }
}

