/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.health.checks.cluster;

import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.host.PgHost;
import io.github.mfvanek.pg.core.checks.common.DatabaseCheckOnHost;
import io.github.mfvanek.pg.core.checks.common.Diagnostic;
import io.github.mfvanek.pg.health.checks.common.DatabaseCheckOnCluster;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

abstract class AbstractCheckOnCluster<T extends DbObject>
implements DatabaseCheckOnCluster<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractCheckOnCluster.class.getName());
    private final HighAvailabilityPgConnection haPgConnection;
    private final Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory;
    private final Map<PgHost, DatabaseCheckOnHost<T>> checksOnHosts;
    private final @Nullable Function<List<List<T>>, List<T>> acrossClusterResultsMapper;

    protected AbstractCheckOnCluster(HighAvailabilityPgConnection haPgConnection, Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory) {
        this(haPgConnection, checkOnHostFactory, null);
    }

    protected AbstractCheckOnCluster(HighAvailabilityPgConnection haPgConnection, Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory, @Nullable Function<List<List<T>>, List<T>> acrossClusterResultsMapper) {
        this.haPgConnection = Objects.requireNonNull(haPgConnection, "haPgConnection cannot be null");
        this.checkOnHostFactory = Objects.requireNonNull(checkOnHostFactory, "checkOnHostFactory cannot be null");
        this.checksOnHosts = new HashMap<PgHost, DatabaseCheckOnHost<T>>();
        this.acrossClusterResultsMapper = acrossClusterResultsMapper;
        DatabaseCheckOnHost<T> checkOnPrimary = this.computeCheckForPrimaryIfNeed();
        if (acrossClusterResultsMapper == null && checkOnPrimary.getDiagnostic().isAcrossCluster()) {
            throw new IllegalArgumentException("acrossClusterResultsMapper cannot be null for diagnostic " + checkOnPrimary.getDiagnostic());
        }
    }

    public Class<T> getType() {
        return this.computeCheckForPrimaryIfNeed().getType();
    }

    public final Diagnostic getDiagnostic() {
        return this.computeCheckForPrimaryIfNeed().getDiagnostic();
    }

    @Override
    public final List<T> check(PgContext pgContext, Predicate<? super T> exclusionsFilter) {
        if (this.getDiagnostic().isAcrossCluster()) {
            return this.executeOnCluster(pgContext, exclusionsFilter);
        }
        return this.executeOnPrimary(pgContext, exclusionsFilter);
    }

    protected void doBeforeExecuteOnHost(PgConnection connectionToHost) {
        LOGGER.fine(() -> "Going to execute on host " + connectionToHost.getHost().getName());
    }

    private DatabaseCheckOnHost<T> computeCheckForPrimaryIfNeed() {
        return this.computeCheckForHostIfNeed(this.haPgConnection.getConnectionToPrimary());
    }

    private DatabaseCheckOnHost<T> computeCheckForHostIfNeed(PgConnection connectionToHost) {
        return this.checksOnHosts.computeIfAbsent(connectionToHost.getHost(), h -> this.checkOnHostFactory.apply(connectionToHost));
    }

    private List<T> executeOnPrimary(PgContext pgContext, Predicate<? super T> exclusionsFilter) {
        DatabaseCheckOnHost checkOnPrimary = this.computeCheckForPrimaryIfNeed();
        LOGGER.fine(() -> "Going to execute on primary host " + checkOnPrimary.getHost().getName());
        return checkOnPrimary.check(pgContext, exclusionsFilter);
    }

    private List<T> executeOnCluster(PgContext pgContext, Predicate<? super T> exclusionsFilter) {
        ArrayList<List<? super T>> acrossClusterResults = new ArrayList<List<? super T>>();
        for (PgConnection pgConnection : this.haPgConnection.getConnectionsToAllHostsInCluster()) {
            this.doBeforeExecuteOnHost(pgConnection);
            List<? super T> resultsFromHost = this.executeOnHost(pgConnection, pgContext, exclusionsFilter);
            acrossClusterResults.add(resultsFromHost);
        }
        return this.acrossClusterResultsMapper.apply(acrossClusterResults);
    }

    private List<T> executeOnHost(PgConnection connectionToHost, PgContext pgContext, Predicate<? super T> exclusionsFilter) {
        DatabaseCheckOnHost<T> checkOnHost = this.computeCheckForHostIfNeed(connectionToHost);
        return checkOnHost.check(pgContext, exclusionsFilter);
    }
}

