/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.health.checks.cluster;

import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.core.checks.host.TablesWithMissingIndexesCheckOnHost;
import io.github.mfvanek.pg.health.checks.cluster.AbstractCheckOnCluster;
import io.github.mfvanek.pg.model.table.TableWithMissingIndex;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TablesWithMissingIndexesCheckOnCluster
extends AbstractCheckOnCluster<TableWithMissingIndex> {
    private static final Logger LOGGER = Logger.getLogger(TablesWithMissingIndexesCheckOnCluster.class.getName());

    public TablesWithMissingIndexesCheckOnCluster(HighAvailabilityPgConnection haPgConnection) {
        super(haPgConnection, TablesWithMissingIndexesCheckOnHost::new, TablesWithMissingIndexesCheckOnCluster::getResultAsUnion);
    }

    static List<TableWithMissingIndex> getResultAsUnion(List<List<TableWithMissingIndex>> tablesWithMissingIndexesFromAllHosts) {
        LOGGER.fine(() -> "tablesWithMissingIndexesFromAllHosts = " + tablesWithMissingIndexesFromAllHosts);
        List<TableWithMissingIndex> result = tablesWithMissingIndexesFromAllHosts.stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        LOGGER.fine(() -> "Union result " + result);
        return result;
    }
}

