/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.health.checks.common;

import io.github.mfvanek.pg.core.checks.common.CheckTypeAware;
import io.github.mfvanek.pg.core.checks.common.DiagnosticAware;
import io.github.mfvanek.pg.core.checks.common.RawTypeAware;
import io.github.mfvanek.pg.model.context.PgContext;
import io.github.mfvanek.pg.model.dbobject.DbObject;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface DatabaseCheckOnCluster<T extends DbObject>
extends DiagnosticAware,
CheckTypeAware,
RawTypeAware<T> {
    public List<T> check(PgContext var1, Predicate<? super T> var2);

    default public List<T> check(PgContext pgContext) {
        return this.check(pgContext, (? super T item) -> true);
    }

    default public List<T> check() {
        return this.check(PgContext.ofDefault(), (? super T item) -> true);
    }

    default public List<T> check(Collection<PgContext> pgContexts, Predicate<? super T> exclusionsFilter) {
        return pgContexts.stream().map(ctx -> this.check((PgContext)ctx, exclusionsFilter)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    default public boolean isRuntime() {
        return this.getDiagnostic().isRuntime();
    }
}

