/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.health.checks.management;

import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.host.PgHost;
import io.github.mfvanek.pg.core.statistics.StatisticsMaintenanceOnHost;
import io.github.mfvanek.pg.health.checks.management.DatabaseManagement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;

public class DatabaseManagementImpl
implements DatabaseManagement {
    private static final Logger LOGGER = Logger.getLogger(DatabaseManagementImpl.class.getName());
    private final HighAvailabilityPgConnection haPgConnection;
    private final Function<PgConnection, StatisticsMaintenanceOnHost> statisticsOnHostFactory;
    private final Map<PgHost, StatisticsMaintenanceOnHost> statistics;

    public DatabaseManagementImpl(HighAvailabilityPgConnection haPgConnection, Function<PgConnection, StatisticsMaintenanceOnHost> statisticsOnHostFactory) {
        this.haPgConnection = Objects.requireNonNull(haPgConnection, "haPgConnection cannot be null");
        this.statisticsOnHostFactory = Objects.requireNonNull(statisticsOnHostFactory, "statisticsOnHostFactory cannot be null");
        this.statistics = new HashMap<PgHost, StatisticsMaintenanceOnHost>();
    }

    @Override
    public boolean resetStatistics() {
        boolean result = true;
        for (PgConnection pgConnection : this.haPgConnection.getConnectionsToAllHostsInCluster()) {
            LOGGER.fine(() -> "Going to execute on host " + pgConnection.getHost().getName());
            boolean resultOnHost = this.computeStatisticsForHostIfNeed(pgConnection).resetStatistics();
            result = result && resultOnHost;
        }
        return result;
    }

    @Override
    public Optional<OffsetDateTime> getLastStatsResetTimestamp() {
        return this.computeStatisticsForHostIfNeed(this.getPrimaryAndLog()).getLastStatsResetTimestamp();
    }

    private PgConnection getPrimaryAndLog() {
        PgConnection connectionToPrimary = this.haPgConnection.getConnectionToPrimary();
        LOGGER.fine(() -> "Going to execute on primary host " + connectionToPrimary.getHost().getName());
        return connectionToPrimary;
    }

    private StatisticsMaintenanceOnHost computeStatisticsForHostIfNeed(PgConnection connectionToHost) {
        return this.statistics.computeIfAbsent(connectionToHost.getHost(), h -> this.statisticsOnHostFactory.apply(connectionToHost));
    }
}

