/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.health.utils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException();
    }

    public static <T> Collection<T> intersection(Collection<? extends T> first, Collection<? extends T> second) {
        Objects.requireNonNull(first, "first cannot be null");
        Set<T> prepared = Set.copyOf(Objects.requireNonNull(second, "second cannot be null"));
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T item : first) {
            if (!prepared.contains(item)) continue;
            result.add(item);
        }
        return result;
    }
}

