/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.cluster;

import io.github.mfvanek.pg.checks.cluster.AbstractCheckOnCluster;
import io.github.mfvanek.pg.checks.host.TablesWithMissingIndexesCheckOnHost;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.model.table.TableWithMissingIndex;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TablesWithMissingIndexesCheckOnCluster
extends AbstractCheckOnCluster<TableWithMissingIndex> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablesWithMissingIndexesCheckOnCluster.class);

    public TablesWithMissingIndexesCheckOnCluster(@Nonnull HighAvailabilityPgConnection haPgConnection) {
        super(haPgConnection, TablesWithMissingIndexesCheckOnHost::new, TablesWithMissingIndexesCheckOnCluster::getResultAsUnion);
    }

    @Nonnull
    static List<TableWithMissingIndex> getResultAsUnion(@Nonnull List<List<TableWithMissingIndex>> tablesWithMissingIndexesFromAllHosts) {
        LOGGER.debug("tablesWithMissingIndexesFromAllHosts = {}", tablesWithMissingIndexesFromAllHosts);
        List<TableWithMissingIndex> result = tablesWithMissingIndexesFromAllHosts.stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
        LOGGER.debug("Union result {}", result);
        return result;
    }
}

