/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.index.IndexWithNulls;
import java.util.List;
import javax.annotation.Nonnull;

public class IndexesWithNullValuesCheckOnHost
extends AbstractCheckOnHost<IndexWithNulls> {
    public IndexesWithNullValuesCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(IndexWithNulls.class, pgConnection, Diagnostic.INDEXES_WITH_NULL_VALUES);
    }

    @Override
    @Nonnull
    public List<IndexWithNulls> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            String indexName = rs.getString("index_name");
            long indexSize = rs.getLong("index_size");
            String nullableField = rs.getString("nullable_fields");
            return IndexWithNulls.of((String)tableName, (String)indexName, (long)indexSize, (String)nullableField);
        });
    }
}

