/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.extractors;

import io.github.mfvanek.pg.common.maintenance.ResultSetExtractor;
import io.github.mfvanek.pg.model.table.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class TableExtractor
implements ResultSetExtractor<Table> {
    private TableExtractor() {
    }

    @Override
    @Nonnull
    public Table extractData(@Nonnull ResultSet resultSet) throws SQLException {
        String tableName = resultSet.getString("table_name");
        long tableSize = resultSet.getLong("table_size");
        return Table.of((String)tableName, (long)tableSize);
    }

    @Nonnull
    public static ResultSetExtractor<Table> of() {
        return new TableExtractor();
    }
}

