/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.host;

import io.github.mfvanek.pg.checks.host.AbstractCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.model.PgContext;
import io.github.mfvanek.pg.model.table.TableWithBloat;
import java.util.List;
import javax.annotation.Nonnull;

public class TablesWithBloatCheckOnHost
extends AbstractCheckOnHost<TableWithBloat> {
    public TablesWithBloatCheckOnHost(@Nonnull PgConnection pgConnection) {
        super(TableWithBloat.class, pgConnection, Diagnostic.BLOATED_TABLES);
    }

    @Override
    @Nonnull
    public List<TableWithBloat> check(@Nonnull PgContext pgContext) {
        return this.executeQuery(pgContext, rs -> {
            String tableName = rs.getString("table_name");
            long tableSize = rs.getLong("table_size");
            long bloatSize = rs.getLong("bloat_size");
            int bloatPercentage = rs.getInt("bloat_percentage");
            return TableWithBloat.of((String)tableName, (long)tableSize, (long)bloatSize, (int)bloatPercentage);
        });
    }
}

