/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.predicates;

import io.github.mfvanek.pg.checks.predicates.AbstractFilterByName;
import io.github.mfvanek.pg.model.index.IndexNameAware;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FilterIndexesByNamePredicate
extends AbstractFilterByName
implements Predicate<IndexNameAware> {
    private FilterIndexesByNamePredicate(@Nonnull Collection<String> exclusions) {
        super(exclusions);
    }

    private FilterIndexesByNamePredicate(@Nonnull String indexName) {
        super(indexName);
    }

    @Override
    public boolean test(@Nonnull IndexNameAware indexNameAware) {
        if (this.exclusions.isEmpty()) {
            return true;
        }
        return !this.exclusions.contains(indexNameAware.getIndexName().toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public static Predicate<IndexNameAware> of(@Nonnull String indexName) {
        return new FilterIndexesByNamePredicate(indexName);
    }

    @Nonnull
    public static Predicate<IndexNameAware> of(@Nonnull Collection<String> exclusions) {
        return new FilterIndexesByNamePredicate(exclusions);
    }
}

