/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.health.logger;

import io.github.mfvanek.pg.common.health.logger.Exclusions;
import io.github.mfvanek.pg.model.MemoryUnit;
import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.validation.AdditionalValidators;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ExclusionsBuilder {
    private static final String THRESHOLD_UNITS_COUNT = "thresholdUnitsCount";
    private static final String EMPTY = "";
    private String duplicatedIndexesExclusions = "";
    private String intersectedIndexesExclusions = "";
    private String unusedIndexesExclusions = "";
    private String tablesWithMissingIndexesExclusions = "";
    private String tablesWithoutPrimaryKeyExclusions = "";
    private String indexesWithNullValuesExclusions = "";
    private long indexSizeThresholdInBytes;
    private long tableSizeThresholdInBytes;
    private long indexBloatSizeThresholdInBytes;
    private int indexBloatPercentageThreshold;
    private long tableBloatSizeThresholdInBytes;
    private int tableBloatPercentageThreshold;

    ExclusionsBuilder() {
    }

    public ExclusionsBuilder withDuplicatedIndexesExclusions(@Nonnull String duplicatedIndexesExclusions) {
        this.duplicatedIndexesExclusions = Objects.requireNonNull(duplicatedIndexesExclusions);
        return this;
    }

    public ExclusionsBuilder withIntersectedIndexesExclusions(@Nonnull String intersectedIndexesExclusions) {
        this.intersectedIndexesExclusions = Objects.requireNonNull(intersectedIndexesExclusions);
        return this;
    }

    public ExclusionsBuilder withUnusedIndexesExclusions(@Nonnull String unusedIndexesExclusions) {
        this.unusedIndexesExclusions = Objects.requireNonNull(unusedIndexesExclusions);
        return this;
    }

    public ExclusionsBuilder withTablesWithMissingIndexesExclusions(@Nonnull String tablesWithMissingIndexesExclusions) {
        this.tablesWithMissingIndexesExclusions = Objects.requireNonNull(tablesWithMissingIndexesExclusions);
        return this;
    }

    public ExclusionsBuilder withTablesWithoutPrimaryKeyExclusions(@Nonnull String tablesWithoutPrimaryKeyExclusions) {
        this.tablesWithoutPrimaryKeyExclusions = Objects.requireNonNull(tablesWithoutPrimaryKeyExclusions);
        return this;
    }

    public ExclusionsBuilder withIndexesWithNullValuesExclusions(@Nonnull String indexesWithNullValuesExclusions) {
        this.indexesWithNullValuesExclusions = Objects.requireNonNull(indexesWithNullValuesExclusions);
        return this;
    }

    public ExclusionsBuilder withIndexSizeThreshold(long indexSizeThresholdInBytes) {
        this.indexSizeThresholdInBytes = Validators.sizeNotNegative((long)indexSizeThresholdInBytes, (String)"indexSizeThresholdInBytes");
        return this;
    }

    public ExclusionsBuilder withIndexSizeThreshold(int thresholdUnitsCount, MemoryUnit unit) {
        long indexSizeInBytes = unit.convertToBytes(Validators.argumentNotNegative((int)thresholdUnitsCount, (String)THRESHOLD_UNITS_COUNT));
        return this.withIndexSizeThreshold(indexSizeInBytes);
    }

    public ExclusionsBuilder withTableSizeThreshold(long tableSizeThresholdInBytes) {
        this.tableSizeThresholdInBytes = Validators.sizeNotNegative((long)tableSizeThresholdInBytes, (String)"tableSizeThresholdInBytes");
        return this;
    }

    public ExclusionsBuilder withTableSizeThreshold(int thresholdUnitsCount, MemoryUnit unit) {
        long tableSizeInBytes = unit.convertToBytes(Validators.argumentNotNegative((int)thresholdUnitsCount, (String)THRESHOLD_UNITS_COUNT));
        return this.withTableSizeThreshold(tableSizeInBytes);
    }

    public ExclusionsBuilder withIndexBloatSizeThreshold(long indexBloatSizeThresholdInBytes) {
        this.indexBloatSizeThresholdInBytes = Validators.sizeNotNegative((long)indexBloatSizeThresholdInBytes, (String)"indexBloatSizeThresholdInBytes");
        return this;
    }

    public ExclusionsBuilder withIndexBloatSizeThreshold(int thresholdUnitsCount, MemoryUnit unit) {
        long indexBloatSizeInBytes = unit.convertToBytes(Validators.argumentNotNegative((int)thresholdUnitsCount, (String)THRESHOLD_UNITS_COUNT));
        return this.withIndexBloatSizeThreshold(indexBloatSizeInBytes);
    }

    public ExclusionsBuilder withIndexBloatPercentageThreshold(int indexBloatPercentageThreshold) {
        this.indexBloatPercentageThreshold = AdditionalValidators.validPercent(indexBloatPercentageThreshold, "indexBloatPercentageThreshold");
        return this;
    }

    public ExclusionsBuilder withTableBloatSizeThreshold(long tableBloatSizeThresholdInBytes) {
        this.tableBloatSizeThresholdInBytes = Validators.sizeNotNegative((long)tableBloatSizeThresholdInBytes, (String)"tableBloatSizeThresholdInBytes");
        return this;
    }

    public ExclusionsBuilder withTableBloatSizeThreshold(int thresholdUnitsCount, MemoryUnit unit) {
        long tableBloatSizeInBytes = unit.convertToBytes(Validators.argumentNotNegative((int)thresholdUnitsCount, (String)THRESHOLD_UNITS_COUNT));
        return this.withTableBloatSizeThreshold(tableBloatSizeInBytes);
    }

    public ExclusionsBuilder withTableBloatPercentageThreshold(int tableBloatPercentageThreshold) {
        this.tableBloatPercentageThreshold = AdditionalValidators.validPercent(tableBloatPercentageThreshold, "tableBloatPercentageThreshold");
        return this;
    }

    public Exclusions build() {
        return new Exclusions(this.duplicatedIndexesExclusions, this.intersectedIndexesExclusions, this.unusedIndexesExclusions, this.tablesWithMissingIndexesExclusions, this.tablesWithoutPrimaryKeyExclusions, this.indexesWithNullValuesExclusions, this.indexSizeThresholdInBytes, this.tableSizeThresholdInBytes, this.indexBloatSizeThresholdInBytes, this.indexBloatPercentageThreshold, this.tableBloatSizeThresholdInBytes, this.tableBloatPercentageThreshold);
    }

    @Nonnull
    public String toString() {
        return ExclusionsBuilder.class.getSimpleName() + "{duplicatedIndexesExclusions='" + this.duplicatedIndexesExclusions + "', intersectedIndexesExclusions='" + this.intersectedIndexesExclusions + "', unusedIndexesExclusions='" + this.unusedIndexesExclusions + "', tablesWithMissingIndexesExclusions='" + this.tablesWithMissingIndexesExclusions + "', tablesWithoutPrimaryKeyExclusions='" + this.tablesWithoutPrimaryKeyExclusions + "', indexesWithNullValuesExclusions='" + this.indexesWithNullValuesExclusions + "', indexSizeThresholdInBytes=" + this.indexSizeThresholdInBytes + ", tableSizeThresholdInBytes=" + this.tableSizeThresholdInBytes + ", indexBloatSizeThresholdInBytes=" + this.indexBloatSizeThresholdInBytes + ", indexBloatPercentageThreshold=" + this.indexBloatPercentageThreshold + ", tableBloatSizeThresholdInBytes=" + this.tableBloatSizeThresholdInBytes + ", tableBloatPercentageThreshold=" + this.tableBloatPercentageThreshold + "}";
    }
}

