/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.settings.maintenance;

import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.settings.ImportantParam;
import io.github.mfvanek.pg.settings.ParamNameAware;
import io.github.mfvanek.pg.settings.PgParam;
import io.github.mfvanek.pg.settings.PgParamImpl;
import io.github.mfvanek.pg.settings.ServerSpecification;
import io.github.mfvanek.pg.settings.maintenance.ConfigurationMaintenanceOnHost;
import io.github.mfvanek.pg.utils.QueryExecutors;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ConfigurationMaintenanceOnHostImpl
implements ConfigurationMaintenanceOnHost {
    private final PgConnection pgConnection;

    public ConfigurationMaintenanceOnHostImpl(@Nonnull PgConnection pgConnection) {
        this.pgConnection = Objects.requireNonNull(pgConnection, "pgConnection cannot be null");
    }

    @Nonnull
    public PgHost getHost() {
        return this.pgConnection.getHost();
    }

    @Override
    @Nonnull
    public Set<PgParam> getParamsWithDefaultValues(@Nonnull ServerSpecification specification) {
        HashSet<PgParam> params = new HashSet<PgParam>();
        for (ImportantParam importantParam : ImportantParam.values()) {
            PgParam currentValue = this.getParamCurrentValue((ParamNameAware)importantParam);
            if (!currentValue.getValue().equals(importantParam.getDefaultValue())) continue;
            params.add(currentValue);
        }
        return params;
    }

    @Override
    @Nonnull
    public Set<PgParam> getParamsCurrentValues() {
        List<PgParam> params = QueryExecutors.executeQuery(this.pgConnection, "show all", rs -> {
            String paramName = rs.getString("name");
            String currentValue = rs.getString("setting");
            return PgParamImpl.of((String)paramName, (String)currentValue);
        });
        return params.stream().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @Nonnull
    public PgParam getParamCurrentValue(@Nonnull ParamNameAware paramName) {
        return this.getCurrentValue(paramName.getName());
    }

    @Nonnull
    private PgParam getCurrentValue(@Nonnull String paramName) {
        String sqlQuery = String.format("show %s;", paramName);
        List<PgParam> params = QueryExecutors.executeQuery(this.pgConnection, sqlQuery, rs -> {
            String currentValue = rs.getString(paramName);
            return PgParamImpl.of((String)paramName, (String)currentValue);
        });
        return params.get(0);
    }
}

