/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.cluster;

import io.github.mfvanek.pg.common.maintenance.DatabaseCheckOnCluster;
import io.github.mfvanek.pg.common.maintenance.DatabaseCheckOnHost;
import io.github.mfvanek.pg.common.maintenance.Diagnostic;
import io.github.mfvanek.pg.connection.HighAvailabilityPgConnection;
import io.github.mfvanek.pg.connection.PgConnection;
import io.github.mfvanek.pg.connection.PgHost;
import io.github.mfvanek.pg.model.DbObject;
import io.github.mfvanek.pg.model.PgContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCheckOnCluster<T extends DbObject>
implements DatabaseCheckOnCluster<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCheckOnCluster.class);
    private final HighAvailabilityPgConnection haPgConnection;
    private final Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory;
    private final Map<PgHost, DatabaseCheckOnHost<T>> checksOnHosts;
    private final Function<List<List<T>>, List<T>> acrossClusterResultsMapper;

    protected AbstractCheckOnCluster(@Nonnull HighAvailabilityPgConnection haPgConnection, @Nonnull Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory) {
        this(haPgConnection, checkOnHostFactory, null);
    }

    protected AbstractCheckOnCluster(@Nonnull HighAvailabilityPgConnection haPgConnection, @Nonnull Function<PgConnection, DatabaseCheckOnHost<T>> checkOnHostFactory, @Nullable Function<List<List<T>>, List<T>> acrossClusterResultsMapper) {
        this.haPgConnection = Objects.requireNonNull(haPgConnection, "haPgConnection cannot be null");
        this.checkOnHostFactory = Objects.requireNonNull(checkOnHostFactory, "checkOnHostFactory cannot be null");
        this.checksOnHosts = new HashMap<PgHost, DatabaseCheckOnHost<T>>();
        this.acrossClusterResultsMapper = acrossClusterResultsMapper;
        DatabaseCheckOnHost<T> checkOnPrimary = this.computeCheckForPrimaryIfNeed();
        if (checkOnPrimary.getDiagnostic().isAcrossCluster() && Objects.isNull(acrossClusterResultsMapper)) {
            throw new IllegalArgumentException("acrossClusterResultsMapper cannot be null for diagnostic " + checkOnPrimary.getDiagnostic());
        }
    }

    @Override
    @Nonnull
    public Class<T> getType() {
        return this.computeCheckForPrimaryIfNeed().getType();
    }

    @Override
    @Nonnull
    public final Diagnostic getDiagnostic() {
        return this.computeCheckForPrimaryIfNeed().getDiagnostic();
    }

    @Override
    @Nonnull
    public final List<T> check(@Nonnull PgContext pgContext, @Nonnull Predicate<? super T> exclusionsFilter) {
        if (this.getDiagnostic().isAcrossCluster()) {
            return this.executeOnCluster(pgContext, exclusionsFilter);
        }
        return this.executeOnPrimary(pgContext, exclusionsFilter);
    }

    protected void doBeforeExecuteOnHost(@Nonnull PgConnection connectionToHost) {
        LOGGER.debug("Going to execute on host {}", (Object)connectionToHost.getHost().getName());
    }

    @Nonnull
    private DatabaseCheckOnHost<T> computeCheckForPrimaryIfNeed() {
        return this.computeCheckForHostIfNeed(this.haPgConnection.getConnectionToPrimary());
    }

    @Nonnull
    private DatabaseCheckOnHost<T> computeCheckForHostIfNeed(@Nonnull PgConnection connectionToHost) {
        return this.checksOnHosts.computeIfAbsent(connectionToHost.getHost(), h -> this.checkOnHostFactory.apply(connectionToHost));
    }

    @Nonnull
    private List<T> executeOnPrimary(@Nonnull PgContext pgContext, @Nonnull Predicate<? super T> exclusionsFilter) {
        DatabaseCheckOnHost<T> checkOnPrimary = this.computeCheckForPrimaryIfNeed();
        LOGGER.debug("Going to execute on primary host {}", (Object)checkOnPrimary.getHost().getName());
        return checkOnPrimary.check(pgContext).stream().filter(exclusionsFilter).collect(Collectors.toList());
    }

    @Nonnull
    private List<T> executeOnCluster(@Nonnull PgContext pgContext, @Nonnull Predicate<? super T> exclusionsFilter) {
        ArrayList<List<T>> acrossClusterResults = new ArrayList<List<T>>();
        for (PgConnection pgConnection : this.haPgConnection.getConnectionsToAllHostsInCluster()) {
            this.doBeforeExecuteOnHost(pgConnection);
            List<T> resultsFromHost = this.executeOnHost(pgConnection, pgContext);
            acrossClusterResults.add(resultsFromHost);
        }
        return this.acrossClusterResultsMapper.apply(acrossClusterResults).stream().filter(exclusionsFilter).collect(Collectors.toList());
    }

    @Nonnull
    private List<T> executeOnHost(@Nonnull PgConnection connectionToHost, @Nonnull PgContext pgContext) {
        DatabaseCheckOnHost<T> checkOnHost = this.computeCheckForHostIfNeed(connectionToHost);
        return checkOnHost.check(pgContext);
    }
}

