/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.extractors;

import io.github.mfvanek.pg.common.maintenance.ResultSetExtractor;
import io.github.mfvanek.pg.model.column.Column;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class ColumnExtractor
implements ResultSetExtractor<Column> {
    private ColumnExtractor() {
    }

    @Override
    @Nonnull
    public Column extractData(@Nonnull ResultSet resultSet) throws SQLException {
        String tableName = resultSet.getString("table_name");
        String columnName = resultSet.getString("column_name");
        boolean columnNotNull = resultSet.getBoolean("column_not_null");
        if (columnNotNull) {
            return Column.ofNotNull((String)tableName, (String)columnName);
        }
        return Column.ofNullable((String)tableName, (String)columnName);
    }

    @Nonnull
    public static ResultSetExtractor<Column> of() {
        return new ColumnExtractor();
    }
}

