/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.extractors;

import io.github.mfvanek.pg.checks.extractors.ColumnExtractor;
import io.github.mfvanek.pg.common.maintenance.ResultSetExtractor;
import io.github.mfvanek.pg.model.column.Column;
import io.github.mfvanek.pg.model.column.ColumnWithSerialType;
import io.github.mfvanek.pg.model.column.SerialType;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;

public class ColumnWithSerialTypeExtractor
implements ResultSetExtractor<ColumnWithSerialType> {
    private final ResultSetExtractor<Column> columnExtractor = ColumnExtractor.of();

    private ColumnWithSerialTypeExtractor() {
    }

    @Override
    @Nonnull
    public ColumnWithSerialType extractData(@Nonnull ResultSet resultSet) throws SQLException {
        Column column = this.columnExtractor.extractData(resultSet);
        String columnType = resultSet.getString("column_type");
        String sequenceName = resultSet.getString("sequence_name");
        return ColumnWithSerialType.of((Column)column, (SerialType)SerialType.valueFrom((String)columnType), (String)sequenceName);
    }

    @Nonnull
    public static ResultSetExtractor<ColumnWithSerialType> of() {
        return new ColumnWithSerialTypeExtractor();
    }
}

