/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.checks.predicates;

import io.github.mfvanek.pg.checks.predicates.AbstractFilterByName;
import io.github.mfvanek.pg.model.table.TableNameAware;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FilterTablesByNamePredicate
extends AbstractFilterByName
implements Predicate<TableNameAware> {
    private FilterTablesByNamePredicate(@Nonnull Collection<String> exclusions) {
        super(exclusions);
    }

    private FilterTablesByNamePredicate(@Nonnull String tableName) {
        super(tableName);
    }

    @Override
    public boolean test(@Nonnull TableNameAware tableNameAware) {
        if (this.exclusions.isEmpty()) {
            return true;
        }
        return !this.exclusions.contains(tableNameAware.getTableName().toLowerCase(Locale.ROOT));
    }

    @Nonnull
    public static Predicate<TableNameAware> of(@Nonnull String tableName) {
        return new FilterTablesByNamePredicate(tableName);
    }

    @Nonnull
    public static Predicate<TableNameAware> of(@Nonnull Collection<String> exclusions) {
        return new FilterTablesByNamePredicate(exclusions);
    }
}

