/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.common.health.logger;

import io.github.mfvanek.pg.common.health.logger.ExclusionsBuilder;
import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.validation.AdditionalValidators;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class Exclusions {
    private final Set<String> duplicatedIndexesExclusions;
    private final Set<String> intersectedIndexesExclusions;
    private final Set<String> unusedIndexesExclusions;
    private final Set<String> tablesWithMissingIndexesExclusions;
    private final Set<String> tablesWithoutPrimaryKeyExclusions;
    private final Set<String> indexesWithNullValuesExclusions;
    private final long indexSizeThresholdInBytes;
    private final long tableSizeThresholdInBytes;
    private final long indexBloatSizeThresholdInBytes;
    private final int indexBloatPercentageThreshold;
    private final long tableBloatSizeThresholdInBytes;
    private final int tableBloatPercentageThreshold;

    Exclusions(@Nonnull String duplicatedIndexesExclusions, @Nonnull String intersectedIndexesExclusions, @Nonnull String unusedIndexesExclusions, @Nonnull String tablesWithMissingIndexesExclusions, @Nonnull String tablesWithoutPrimaryKeyExclusions, @Nonnull String indexesWithNullValuesExclusions, long indexSizeThresholdInBytes, long tableSizeThresholdInBytes, long indexBloatSizeThresholdInBytes, int indexBloatPercentageThreshold, long tableBloatSizeThresholdInBytes, int tableBloatPercentageThreshold) {
        this.duplicatedIndexesExclusions = Exclusions.prepareExclusions(duplicatedIndexesExclusions);
        this.intersectedIndexesExclusions = Exclusions.prepareExclusions(intersectedIndexesExclusions);
        this.unusedIndexesExclusions = Exclusions.prepareExclusions(unusedIndexesExclusions);
        this.tablesWithMissingIndexesExclusions = Exclusions.prepareExclusions(tablesWithMissingIndexesExclusions);
        this.tablesWithoutPrimaryKeyExclusions = Exclusions.prepareExclusions(tablesWithoutPrimaryKeyExclusions);
        this.indexesWithNullValuesExclusions = Exclusions.prepareExclusions(indexesWithNullValuesExclusions);
        this.indexSizeThresholdInBytes = Validators.sizeNotNegative((long)indexSizeThresholdInBytes, (String)"indexSizeThresholdInBytes");
        this.tableSizeThresholdInBytes = Validators.sizeNotNegative((long)tableSizeThresholdInBytes, (String)"tableSizeThresholdInBytes");
        this.indexBloatSizeThresholdInBytes = Validators.sizeNotNegative((long)indexBloatSizeThresholdInBytes, (String)"indexBloatSizeThresholdInBytes");
        this.indexBloatPercentageThreshold = AdditionalValidators.validPercent(indexBloatPercentageThreshold, "indexBloatPercentageThreshold");
        this.tableBloatSizeThresholdInBytes = Validators.sizeNotNegative((long)tableBloatSizeThresholdInBytes, (String)"tableBloatSizeThresholdInBytes");
        this.tableBloatPercentageThreshold = AdditionalValidators.validPercent(tableBloatPercentageThreshold, "tableBloatPercentageThreshold");
    }

    private static Set<String> prepareExclusions(@Nonnull String rawExclusions) {
        Objects.requireNonNull(rawExclusions, "rawExclusions cannot be null");
        HashSet<String> exclusions = new HashSet<String>();
        if (!rawExclusions.isBlank()) {
            String[] tables;
            for (String tableName : tables = rawExclusions.toLowerCase(Locale.ROOT).split(",")) {
                if (tableName.isBlank()) continue;
                exclusions.add(tableName.trim());
            }
        }
        return exclusions;
    }

    @Nonnull
    Set<String> getDuplicatedIndexesExclusions() {
        return this.duplicatedIndexesExclusions;
    }

    @Nonnull
    Set<String> getIntersectedIndexesExclusions() {
        return this.intersectedIndexesExclusions;
    }

    @Nonnull
    Set<String> getUnusedIndexesExclusions() {
        return this.unusedIndexesExclusions;
    }

    @Nonnull
    Set<String> getTablesWithMissingIndexesExclusions() {
        return this.tablesWithMissingIndexesExclusions;
    }

    @Nonnull
    Set<String> getTablesWithoutPrimaryKeyExclusions() {
        return this.tablesWithoutPrimaryKeyExclusions;
    }

    @Nonnull
    Set<String> getIndexesWithNullValuesExclusions() {
        return this.indexesWithNullValuesExclusions;
    }

    long getIndexSizeThresholdInBytes() {
        return this.indexSizeThresholdInBytes;
    }

    long getTableSizeThresholdInBytes() {
        return this.tableSizeThresholdInBytes;
    }

    long getIndexBloatSizeThresholdInBytes() {
        return this.indexBloatSizeThresholdInBytes;
    }

    int getIndexBloatPercentageThreshold() {
        return this.indexBloatPercentageThreshold;
    }

    public long getTableBloatSizeThresholdInBytes() {
        return this.tableBloatSizeThresholdInBytes;
    }

    public int getTableBloatPercentageThreshold() {
        return this.tableBloatPercentageThreshold;
    }

    @Nonnull
    public String toString() {
        return Exclusions.class.getSimpleName() + "{duplicatedIndexesExclusions=" + this.duplicatedIndexesExclusions + ", intersectedIndexesExclusions=" + this.intersectedIndexesExclusions + ", unusedIndexesExclusions=" + this.unusedIndexesExclusions + ", tablesWithMissingIndexesExclusions=" + this.tablesWithMissingIndexesExclusions + ", tablesWithoutPrimaryKeyExclusions=" + this.tablesWithoutPrimaryKeyExclusions + ", indexesWithNullValuesExclusions=" + this.indexesWithNullValuesExclusions + ", indexSizeThresholdInBytes=" + this.indexSizeThresholdInBytes + ", tableSizeThresholdInBytes=" + this.tableSizeThresholdInBytes + ", indexBloatSizeThresholdInBytes=" + this.indexBloatSizeThresholdInBytes + ", indexBloatPercentageThreshold=" + this.indexBloatPercentageThreshold + ", tableBloatSizeThresholdInBytes=" + this.tableBloatSizeThresholdInBytes + ", tableBloatPercentageThreshold=" + this.tableBloatPercentageThreshold + "}";
    }

    public static Exclusions empty() {
        return Exclusions.builder().build();
    }

    public static ExclusionsBuilder builder() {
        return new ExclusionsBuilder();
    }
}

