/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import io.github.mfvanek.pg.model.validation.Validators;
import javax.annotation.Nonnull;

public final class NamedParametersParser {
    private final String originalSqlQuery;
    private final int queryLength;
    private boolean isInSingleQuotes;
    private boolean isInDoubleQuotes;
    private boolean isPartOfSingleLineComment;
    private boolean isPartOfMultiLineComment;
    private boolean isDoubleColon;

    private NamedParametersParser(@Nonnull String originalSqlQuery) {
        this.originalSqlQuery = Validators.notBlank((String)originalSqlQuery, (String)"originalSqlQuery");
        this.queryLength = originalSqlQuery.length();
    }

    @Nonnull
    private String doParse() {
        StringBuilder resultQuery = new StringBuilder(this.queryLength);
        for (int i = 0; i < this.queryLength; ++i) {
            int c = this.originalSqlQuery.charAt(i);
            if (this.isInSingleQuotes) {
                if (c == 39) {
                    this.isInSingleQuotes = false;
                }
            } else if (this.isInDoubleQuotes) {
                if (c == 34) {
                    this.isInDoubleQuotes = false;
                }
            } else if (this.isPartOfMultiLineComment) {
                if (c == 42 && this.nextChar(i) == '/') {
                    this.isPartOfMultiLineComment = false;
                }
            } else if (this.isDoubleColon) {
                this.isDoubleColon = false;
            } else if (this.isPartOfSingleLineComment) {
                if (c == 10) {
                    this.isPartOfSingleLineComment = false;
                }
            } else if (c == 39) {
                this.isInSingleQuotes = true;
            } else if (c == 34) {
                this.isInDoubleQuotes = true;
            } else if (c == 47 && this.nextChar(i) == '*') {
                this.isPartOfMultiLineComment = true;
            } else if (c == 45 && this.nextChar(i) == '-') {
                this.isPartOfSingleLineComment = true;
            } else if (c == 58 && this.hasNextChar(i) && this.nextChar(i) == ':') {
                this.isDoubleColon = true;
            } else if (c == 58 && this.hasNextChar(i) && Character.isJavaIdentifierStart(this.nextChar(i))) {
                int j;
                for (j = i + 2; j < this.queryLength && Character.isJavaIdentifierPart(this.originalSqlQuery.charAt(j)); ++j) {
                }
                c = 63;
                i = j - 1;
            }
            resultQuery.append((char)c);
        }
        return resultQuery.toString();
    }

    private char nextChar(int currentPosition) {
        return this.originalSqlQuery.charAt(currentPosition + 1);
    }

    private boolean hasNextChar(int currentPosition) {
        return currentPosition + 1 < this.queryLength;
    }

    @Nonnull
    public static String parse(@Nonnull String originalSqlQuery) {
        return new NamedParametersParser(originalSqlQuery).doParse();
    }
}

