/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfvanek.pg.utils;

import io.github.mfvanek.pg.model.validation.Validators;
import io.github.mfvanek.pg.utils.NamedParametersParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlQueryReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlQueryReader.class);

    private SqlQueryReader() {
        throw new UnsupportedOperationException();
    }

    public static String getQueryFromFile(@Nonnull String sqlFileName) {
        String string;
        block9: {
            String fileName = SqlQueryReader.validateSqlFileName(sqlFileName);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("sql/" + fileName);
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException(fileName);
                }
                String sqlQueryFromFile = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                LOGGER.trace("Query from file {}", (Object)sqlQueryFromFile);
                string = NamedParametersParser.parse(sqlQueryFromFile);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Nonnull
    private static String validateSqlFileName(@Nonnull String sqlFileName) {
        String fileName = Validators.notBlank((String)sqlFileName, (String)"sqlFileName").toLowerCase(Locale.ROOT);
        if (!fileName.endsWith(".sql")) {
            throw new IllegalArgumentException("only *.sql files are supported");
        }
        return fileName;
    }
}

