/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaelboyles.s3extension;

import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

abstract class AbstractWagon
implements Wagon {
    private Repository repository;
    private int timeout;
    private int readTimeout;
    private boolean isInteractive;

    AbstractWagon() {
    }

    public Repository getRepository() {
        return this.repository;
    }

    protected void setRepository(Repository repository) {
        this.repository = Objects.requireNonNull(repository);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    @Deprecated
    public void openConnection() {
        throw new RuntimeException("Never call openConnection");
    }

    public void connect(Repository repository) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, null);
    }

    public void connect(Repository repository, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfo);
    }

    public void connect(Repository repository, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        this.connect(repository, null, proxyInfoProvider);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo) throws ConnectionException, AuthenticationException {
        this.connect(repository, authenticationInfo, null);
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) throws ConnectionException, AuthenticationException {
        ProxyInfo proxy = proxyInfo;
        this.connect(repository, authenticationInfo, protocol -> {
            if (protocol == null || proxy == null || protocol.equalsIgnoreCase(proxy.getType())) {
                return proxy;
            }
            return null;
        });
    }

    public List<String> getFileList(String destinationDirectory) {
        throw new UnsupportedOperationException("getFileList is not supported");
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) {
        throw new UnsupportedOperationException("putDirectory is not supported");
    }
}

