/*
 * Decompiled with CFR 0.152.
 */
package io.github.michaelboyles.s3extension;

import io.github.michaelboyles.s3extension.AbstractWagon;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.SessionEvent;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;

abstract class ListeningWagon
extends AbstractWagon {
    private final List<TransferListener> transferListeners = new CopyOnWriteArrayList<TransferListener>();
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();

    ListeningWagon() {
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(Objects.requireNonNull(listener));
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public boolean hasSessionListener(SessionListener listener) {
        return this.sessionListeners.contains(listener);
    }

    protected void fireSessionOpening() {
        this.notifySessionListeners(5, SessionListener::sessionOpening);
    }

    protected void fireSessionOpened() {
        this.notifySessionListeners(6, SessionListener::sessionOpened);
    }

    protected void fireSessionDisconnecting() {
        this.notifySessionListeners(2, SessionListener::sessionDisconnecting);
    }

    protected void fireSessionDisconnected() {
        this.notifySessionListeners(3, SessionListener::sessionDisconnected);
    }

    protected void fireSessionLoggedIn() {
        this.notifySessionListeners(7, SessionListener::sessionLoggedIn);
    }

    protected void fireSessionLoggedOff() {
        this.notifySessionListeners(8, SessionListener::sessionLoggedOff);
    }

    private void notifySessionListeners(int eventType, BiConsumer<SessionListener, SessionEvent> handler) {
        SessionEvent event = new SessionEvent((Wagon)this, eventType);
        for (SessionListener listener : this.sessionListeners) {
            handler.accept(listener, event);
        }
    }

    public void addTransferListener(TransferListener listener) {
        this.transferListeners.add(Objects.requireNonNull(listener));
    }

    public void removeTransferListener(TransferListener listener) {
        this.transferListeners.remove(listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return this.transferListeners.contains(listener);
    }

    protected void fireGetTransferInitiated(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(0, 5, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferInitiated);
    }

    protected void firePutTransferInitiated(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(0, 6, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferInitiated);
    }

    protected void fireGetTransferStarted(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(1, 5, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferStarted);
    }

    protected void firePutTransferStarted(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(1, 6, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferStarted);
    }

    protected void fireGetTransferProgress(Resource resource, File destination, byte[] buffer, int length) {
        TransferEvent event = this.newTransferEvent(3, 5, resource, destination);
        for (TransferListener listener : this.transferListeners) {
            listener.transferProgress(event, buffer, length);
        }
    }

    protected void firePutTransferProgress(Resource resource, File destination, byte[] buffer, int length) {
        TransferEvent event = this.newTransferEvent(3, 6, resource, destination);
        for (TransferListener listener : this.transferListeners) {
            listener.transferProgress(event, buffer, length);
        }
    }

    protected void fireGetTransferCompleted(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(2, 5, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferCompleted);
    }

    protected void firePutTransferCompleted(Resource resource, File localFile) {
        TransferEvent event = this.newTransferEvent(2, 6, resource, localFile);
        this.notifyTransferListeners(event, TransferListener::transferCompleted);
    }

    private TransferEvent newTransferEvent(int eventType, int requestType, Resource resource, File localFile) {
        TransferEvent event = new TransferEvent((Wagon)this, resource, eventType, requestType);
        event.setTimestamp(System.currentTimeMillis());
        event.setLocalFile(localFile);
        return event;
    }

    private void notifyTransferListeners(TransferEvent event, BiConsumer<TransferListener, TransferEvent> handler) {
        for (TransferListener listener : this.transferListeners) {
            handler.accept(listener, event);
        }
    }
}

